<?php
require_once('utility.php');
require_once('MasterModeConfiguration.php');

function remove_cluster($argv)
{
    global $DTASCFG_XML_FILE, $CLUSTER_DTASCFG_XML_FILE, $BACKEND;

    if (count($argv) != 2) {
        echo "Usage: remove_cluster SANDBOX_CONTROLLER_ID SELECT_ROLE_PAGE_TITLE\n";
        exit(1);
    }

    $sc_id = $argv[0];
    $select_role_page_title = $argv[1];

    $cfg_xml = simplexml_load_file($DTASCFG_XML_FILE);

    $is_cluster_accessible = isClusterAccessible($DTASCFG_XML_FILE, $sc_id);
    if(!$is_cluster_accessible) exit(2);

    $db_host = chop($cfg_xml->db->host);
    $db_user = chop($cfg_xml->db->username);
    $db_password = $cfg_xml->db->password;

    $sandbox_controller_admin_username = chop($cfg_xml->sandbox_controller->admin_username);
    $sandbox_controller_admin_password = $cfg_xml->sandbox_controller->admin_password;
    $sandbox_number_for_cluster = chop($cfg_xml->sandbox->number);

    dtascfg_get_cluster_exsi_config($sc_id, $esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_vmpath);

    // Escape variables since then they will be used in command line
    $escaped_esxi_username = escapeshellarg($esxi_username);
    $escaped_esxi_password = escapeshellarg($esxi_password);
    $escaped_sandbox_controller_admin_username = escapeshellarg($sandbox_controller_admin_username);
    $escaped_sandbox_controller_admin_password = escapeshellarg($sandbox_controller_admin_password);

    start_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_vmpath);

    $sandbox_controller_prefix = chop($cfg_xml->sandbox_controller->prefix);
    $controller_vix_vmpath = get_vm_vixpath($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_prefix);

    unset($result_array);
    exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" /bin/rm /opt/TrendMicro/DTAS/SandboxController/sccfg.xml 2>&1", $result_array, $return_value);
    if ($return_value != 0) print_error($result_array, $return_value);

    unset($result_array);
    exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" /bin/mv /etc/dtascfg.xml.backup /etc/dtascfg.xml 2>&1", $result_array, $return_value);
    if ($return_value != 0) print_error($result_array, $return_value);

    // reset management server to master mode
    $value = $cfg_xml->xpath("/configuration/cluster_$sc_id/management_server/image_path");
    if (!array_key_exists(0, $value)) {
        echo "Can not find management server image path for cluster specified\n";
        exit(1);
    }

    $management_server_image_path = $value[0];
    $management_server_admin_username = chop($cfg_xml->management_server->admin_username);
    $management_server_admin_password = $cfg_xml->management_server->admin_password;
    $management_server_prefix = chop($cfg_xml->management_server->prefix);

    start_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $management_server_image_path);
    $management_server_vix_vmpath = get_vm_vixpath($esxi_ip, $esxi_username, $esxi_password, $management_server_prefix);

    do {
        exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $management_server_admin_username $management_server_admin_password \"$management_server_vix_vmpath\" /usr/bin/php /opt/TrendMicro/Pixiebob/textUI/backend.php check_postgresql_is_running 2>&1", $result_array, $return_value);
    } while ($return_value != 0);

    try {
        $cluster_cfg_retriever = new ClusterConfigRetriever($DTASCFG_XML_FILE);
        $cluster_cfg_retriever->getClusterConfig($sc_id, $CLUSTER_DTASCFG_XML_FILE);
        //
        $web_console_switch = new WebConsoleSwitch($CLUSTER_DTASCFG_XML_FILE);
        $web_console_switch->turnOnConsole();
        //
        enableClusterMasterMode($CLUSTER_DTASCFG_XML_FILE);
        reloadRolePage($CLUSTER_DTASCFG_XML_FILE, $select_role_page_title);
        rollBackGatewaySetting($CLUSTER_DTASCFG_XML_FILE);

    } catch (Exception $e) {
        debug_print("Caught exception:" . var_export($e, true));
        echo $e->getMessage();
        exit(1);
    }


    if (($db_connect = pg_connect("host=$db_host dbname=dtasdb port=5432 user=$db_user password=$db_password")) == FALSE) {
        echo "Failed to connect to database\n";
        exit(1);
    }

    try {
        if (pg_query_params($db_connect, 'DELETE FROM tb_sc_info WHERE sc_id=$1', array($sc_id)) == FALSE) {
            $err_msg = pg_last_error();
            throw new Exception("Failed to delete sc id ($sc_id) from tb_sc_info, error message: $err_msg");
        }

        if (pg_query_params($db_connect, 'DELETE FROM tb_global_setting WHERE key LIKE $1', array("configuration.cluster_$sc_id.%")) == FALSE) {
            $err_msg = pg_last_error();
            throw new Exception("Failed to delete cluster configuration from tb_global_setting, error message: $err_msg");
        }

        // update total number of sandboxes
        unset($db_result);
        if (($db_result = pg_query_params($db_connect, 'SELECT value FROM tb_global_setting WHERE key=$1', array("configuration.sandbox.total_number"))) == FALSE) {
            $err_msg = pg_last_error();
            throw new Exception("Failed to select key (configuration.sandbox.total_number) from tb_global_setting, error message: $err_msg");
        }
        $db_result = pg_fetch_array($db_result, null, PGSQL_NUM);

        $total_number = $db_result[0] - $sandbox_number_for_cluster;
        if (pg_query_params($db_connect, 'UPDATE tb_global_setting SET value=$1 WHERE key=$2', array($total_number, "configuration.sandbox.total_number")) == FALSE) {
            $err_msg = pg_last_error();
            throw new Exception("Failed to update key (configuration.sandbox.total_number) to tb_global_setting, error message: $err_msg");
        }

        $CLUSTER_SC_ID_LOWER_BOUND = 2;
        if (($db_result = pg_query_params($db_connect, 'SELECT count(*) from tb_sc_info where sc_id >= $1', array($CLUSTER_SC_ID_LOWER_BOUND))) == FALSE) {
            $err_msg = pg_last_error();
            throw new Exception("Failed to update key (configuration.sandbox.total_number) to tb_global_setting, error message: $err_msg");
        }

        $db_result = pg_fetch_array($db_result, null, PGSQL_NUM);
        $cluster_count = (int)$db_result[0];
        if ($cluster_count == 0) {
            enableMasterSwitchable($DTASCFG_XML_FILE);
        }

        pg_query($db_connect, 'COMMIT');
        pg_close($db_connect);
    } catch (Exception $e) {
        echo "Exception caught: " . $e->getMessage();

        pg_query($db_connect, 'ROLLBACK');

        if ($db_connect !== false) {
            pg_close($db_connect);
        }

        exit(1);
    }
}

function doRollBackGatewaySetting($cluster_cfg_path)
{
    $cluster_gateway_retriever = new GatewayRetriever($cluster_cfg_path);
    $cluster_gateway = $cluster_gateway_retriever->getGateway();
    $cluster_gateway_info = $cluster_gateway_retriever->getGatewayInfo();
    return $cluster_gateway->setGatewayInfo($cluster_gateway_info);
}

function reloadRolePage($CLUSTER_DTASCFG_XML_FILE, $select_role_page_title)
{
    $text_ui_role_page_reload_adapter = new TextUIRolePageReloadAdapter($CLUSTER_DTASCFG_XML_FILE, $select_role_page_title);
    $text_ui_role_page_reload_adapter->reload();
}

function enableClusterMasterMode($cluster_cfg_path)
{
    $master_mode_config = new MasterModeConfiguration($cluster_cfg_path);
    $master_mode_config->enableMasterMode();
    $master_mode_config->enableSwitchable();
    $master_mode_config->notifyConfigChange();
}

function rollBackGatewaySetting($cluster_cfg_path)
{
    $ret = doRollBackGatewaySetting($cluster_cfg_path);
    if (!$ret) throw new Exception("Rollback cluster gateway setting fail");
}

function enableMasterSwitchable($cfg_path)
{
    $master_mode_config = new MasterModeConfiguration($cfg_path);
    $master_mode_config->enableSwitchable();
    $master_mode_config->notifyConfigChange();
}

function isClusterAccessible($cfg_xml_path, $sc_id)
{
    try {
        $cluster_ms_ssh_cmd_retriever = new ClusterManagementServerSSHCmdRetriever($cfg_xml_path, $sc_id);
        $cluster_ms_ssh_cmd_retriever->getSSHCmd();
        return true;
    } catch (Exception $e) {
        debug_print("Cannot connect to cluster $sc_id " . $e->getMessage());
        return false;
    }
}

class TextUIRolePageReloadAdapter
{
    protected $_ssh_cmd = null;
    protected $_role_page_title = null;

    const CMD_TEMPLATE_PGREP_ROLE_PAGE_DIALOG = "pgrep -f 'dialog.*--title %s' ";
    const CMD_TEMPLATE_KILL_PROCESS = "kill $(%s)";

    function __construct($cfg_xml_path, $role_page_title) {
        $ms_ssh_cmd_retriever = new ManagementServerSSHCmdRetriever($cfg_xml_path);
        $this->_ssh_cmd = $ms_ssh_cmd_retriever->getSSHCmd();
        $this->_role_page_title = $role_page_title;
    }

    public function reload() {
        $cmd_pgrep_role_page_dialog = sprintf(TextUIRolePageReloadAdapter::CMD_TEMPLATE_PGREP_ROLE_PAGE_DIALOG, $this->_role_page_title);
        $cmd_kill_process =  sprintf(TextUIRolePageReloadAdapter::CMD_TEMPLATE_KILL_PROCESS, $cmd_pgrep_role_page_dialog);
        $this->_ssh_cmd->doCmd($cmd_kill_process);
    }
}
